/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter.internal.mimemessage;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.Address;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.AddressException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import javax.mail.util.ByteArrayDataSource;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageParseException;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.NaturalEntryKeyComparator;

public final class MimeMessageParser {
    private static final List<String> HEADERS_TO_IGNORE = new ArrayList<String>();

    public static ParsedMimeMessageComponents parseMimeMessage(@Nonnull MimeMessage mimeMessage) {
        ParsedMimeMessageComponents parsedComponents = new ParsedMimeMessageComponents();
        parsedComponents.messageId = MimeMessageParser.parseMessageId(mimeMessage);
        parsedComponents.subject = MimeMessageParser.parseSubject(mimeMessage);
        parsedComponents.toAddresses.addAll(MimeMessageParser.parseToAddresses(mimeMessage));
        parsedComponents.ccAddresses.addAll(MimeMessageParser.parseCcAddresses(mimeMessage));
        parsedComponents.bccAddresses.addAll(MimeMessageParser.parseBccAddresses(mimeMessage));
        parsedComponents.fromAddress = MimeMessageParser.parseFromAddress(mimeMessage);
        parsedComponents.replyToAddresses = MimeMessageParser.parseReplyToAddresses(mimeMessage);
        MimeMessageParser.parseMimePartTree((MimePart)mimeMessage, parsedComponents);
        MimeMessageParser.moveInvalidEmbeddedResourcesToAttachments(parsedComponents);
        return parsedComponents;
    }

    private static void parseMimePartTree(@Nonnull MimePart currentPart, @Nonnull ParsedMimeMessageComponents parsedComponents) {
        for (Header header : MimeMessageParser.retrieveAllHeaders(currentPart)) {
            MimeMessageParser.parseHeader(header, parsedComponents);
        }
        String disposition = MimeMessageParser.parseDisposition(currentPart);
        if (MimeMessageParser.isMimeType(currentPart, "text/plain") && parsedComponents.plainContent == null && !"attachment".equalsIgnoreCase(disposition)) {
            parsedComponents.plainContent = (String)MimeMessageParser.parseContent(currentPart);
        } else if (MimeMessageParser.isMimeType(currentPart, "text/html") && parsedComponents.htmlContent == null && !"attachment".equalsIgnoreCase(disposition)) {
            parsedComponents.htmlContent = (String)MimeMessageParser.parseContent(currentPart);
        } else if (MimeMessageParser.isMimeType(currentPart, "multipart/*")) {
            Multipart mp = (Multipart)MimeMessageParser.parseContent(currentPart);
            int count = MimeMessageParser.countBodyParts(mp);
            for (int i = 0; i < count; ++i) {
                MimeMessageParser.parseMimePartTree((MimePart)MimeMessageParser.getBodyPartAtIndex(mp, i), parsedComponents);
            }
        } else {
            DataSource ds = MimeMessageParser.createDataSource(currentPart);
            if ("attachment".equalsIgnoreCase(disposition)) {
                parsedComponents.attachmentList.add(new AbstractMap.SimpleEntry<String, DataSource>(MimeMessageParser.parseResourceNameOrUnnamed(MimeMessageParser.parseContentID(currentPart), MimeMessageParser.parseFileName((Part)currentPart)), ds));
            } else if (disposition == null || "inline".equalsIgnoreCase(disposition)) {
                if (MimeMessageParser.parseContentID(currentPart) != null) {
                    parsedComponents.cidMap.put(MimeMessageParser.parseContentID(currentPart), ds);
                } else {
                    parsedComponents.attachmentList.add(new AbstractMap.SimpleEntry<String, DataSource>(MimeMessageParser.parseResourceNameOrUnnamed(null, MimeMessageParser.parseFileName((Part)currentPart)), ds));
                }
            } else {
                throw new IllegalStateException("invalid attachment type");
            }
        }
    }

    private static void parseHeader(Header header, @Nonnull ParsedMimeMessageComponents parsedComponents) {
        if (header.getName().equals("Disposition-Notification-To")) {
            parsedComponents.dispositionNotificationTo = MimeMessageParser.createAddress(header, "Disposition-Notification-To");
        } else if (header.getName().equals("Return-Receipt-To")) {
            parsedComponents.returnReceiptTo = MimeMessageParser.createAddress(header, "Return-Receipt-To");
        } else if (header.getName().equals("Return-Path")) {
            parsedComponents.bounceToAddress = MimeMessageParser.createAddress(header, "Return-Path");
        } else if (!HEADERS_TO_IGNORE.contains(header.getName())) {
            parsedComponents.headers.put(header.getName(), header.getValue());
        }
    }

    public static String parseFileName(@Nonnull Part currentPart) {
        try {
            return currentPart.getFileName();
        }
        catch (MessagingException e) {
            throw new MimeMessageParseException("Error getting file name", (Exception)((Object)e));
        }
    }

    @Nullable
    public static String parseContentID(@Nonnull MimePart currentPart) {
        try {
            return currentPart.getContentID();
        }
        catch (MessagingException e) {
            throw new MimeMessageParseException("Error getting content ID", (Exception)((Object)e));
        }
    }

    public static MimeBodyPart getBodyPartAtIndex(Multipart parentMultiPart, int index) {
        try {
            return (MimeBodyPart)parentMultiPart.getBodyPart(index);
        }
        catch (MessagingException e) {
            throw new MimeMessageParseException(String.format("Error getting bodypart at index %s", index), (Exception)((Object)e));
        }
    }

    public static int countBodyParts(Multipart mp) {
        try {
            return mp.getCount();
        }
        catch (MessagingException e) {
            throw new MimeMessageParseException("Error parsing MimeMessage multipart count", (Exception)((Object)e));
        }
    }

    public static <T> T parseContent(@Nonnull MimePart currentPart) {
        try {
            return (T)currentPart.getContent();
        }
        catch (IOException | MessagingException e) {
            throw new MimeMessageParseException("Error parsing MimeMessage Content", (Exception)e);
        }
    }

    public static String parseDisposition(@Nonnull MimePart currentPart) {
        try {
            return currentPart.getDisposition();
        }
        catch (MessagingException e) {
            throw new MimeMessageParseException("Error parsing MimeMessage disposition", (Exception)((Object)e));
        }
    }

    @Nonnull
    private static String parseResourceNameOrUnnamed(@Nullable String possibleWrappedContentID, @Nonnull String fileName) {
        String resourceName = MimeMessageParser.parseResourceName(possibleWrappedContentID, fileName);
        return MiscUtil.valueNullOrEmpty(resourceName) ? "unnamed" : resourceName;
    }

    @Nonnull
    private static String parseResourceName(@Nullable String possibleWrappedContentID, @Nonnull String fileName) {
        if (!MiscUtil.valueNullOrEmpty(possibleWrappedContentID)) {
            String unwrappedContentID = possibleWrappedContentID.replaceAll("^<?(.*?)>?$", "$1");
            String extension = !MiscUtil.valueNullOrEmpty(fileName) && fileName.contains(".") ? fileName.substring(fileName.lastIndexOf(".")) : "";
            return unwrappedContentID.endsWith(extension) ? unwrappedContentID : unwrappedContentID + extension;
        }
        return fileName;
    }

    @Nonnull
    public static List<Header> retrieveAllHeaders(@Nonnull MimePart part) {
        try {
            return Collections.list(part.getAllHeaders());
        }
        catch (MessagingException e) {
            throw new MimeMessageParseException("Error getting all headers", (Exception)((Object)e));
        }
    }

    @Nonnull
    private static InternetAddress createAddress(Header header, String typeOfAddress) {
        try {
            return new InternetAddress(header.getValue());
        }
        catch (AddressException e) {
            throw new MimeMessageParseException(String.format("Error parsing [%s] address", typeOfAddress), (Exception)((Object)e));
        }
    }

    public static boolean isMimeType(@Nonnull MimePart part, @Nonnull String mimeType) {
        try {
            ContentType contentType = new ContentType(MimeMessageParser.retrieveDataHandler(part).getContentType());
            return contentType.match(mimeType);
        }
        catch (ParseException ex) {
            return MimeMessageParser.retrieveContentType(part).equalsIgnoreCase(mimeType);
        }
    }

    public static String retrieveContentType(@Nonnull MimePart part) {
        try {
            return part.getContentType();
        }
        catch (MessagingException e) {
            throw new MimeMessageParseException("Error getting content type", (Exception)((Object)e));
        }
    }

    public static DataHandler retrieveDataHandler(@Nonnull MimePart part) {
        try {
            return part.getDataHandler();
        }
        catch (MessagingException e) {
            throw new MimeMessageParseException("Error getting data handler", (Exception)((Object)e));
        }
    }

    @Nonnull
    private static DataSource createDataSource(@Nonnull MimePart part) {
        DataHandler dataHandler = MimeMessageParser.retrieveDataHandler(part);
        DataSource dataSource = dataHandler.getDataSource();
        String contentType = MimeMessageParser.parseBaseMimeType(dataSource.getContentType());
        byte[] content = MimeMessageParser.readContent(MimeMessageParser.retrieveInputStream(dataSource));
        ByteArrayDataSource result = new ByteArrayDataSource(content, contentType);
        String dataSourceName = MimeMessageParser.parseDataSourceName((Part)part, dataSource);
        result.setName(dataSourceName);
        return result;
    }

    public static InputStream retrieveInputStream(DataSource dataSource) {
        try {
            return dataSource.getInputStream();
        }
        catch (IOException e) {
            throw new MimeMessageParseException("Error getting input stream", e);
        }
    }

    @Nullable
    private static String parseDataSourceName(@Nonnull Part part, @Nonnull DataSource dataSource) {
        String result = !MiscUtil.valueNullOrEmpty(dataSource.getName()) ? dataSource.getName() : MimeMessageParser.parseFileName(part);
        return !MiscUtil.valueNullOrEmpty(result) ? MimeMessageParser.decodeText(result) : null;
    }

    @Nonnull
    private static String decodeText(@Nonnull String result) {
        try {
            return MimeUtility.decodeText((String)result);
        }
        catch (UnsupportedEncodingException e) {
            throw new MimeMessageParseException("Error decoding text", e);
        }
    }

    @Nonnull
    private static byte[] readContent(@Nonnull InputStream is) {
        BufferedInputStream isReader = new BufferedInputStream(is);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        BufferedOutputStream osWriter = new BufferedOutputStream(os);
        try {
            int ch;
            while ((ch = isReader.read()) != -1) {
                osWriter.write(ch);
            }
            osWriter.flush();
            byte[] result = os.toByteArray();
            osWriter.close();
            return result;
        }
        catch (IOException e) {
            throw new MimeMessageParseException("Error reading content", e);
        }
    }

    @Nonnull
    private static String parseBaseMimeType(@Nonnull String fullMimeType) {
        int pos = fullMimeType.indexOf(59);
        if (pos >= 0) {
            return fullMimeType.substring(0, pos);
        }
        return fullMimeType;
    }

    @Nonnull
    public static List<InternetAddress> parseToAddresses(@Nonnull MimeMessage mimeMessage) {
        return MimeMessageParser.parseInternetAddresses(MimeMessageParser.retrieveRecipients(mimeMessage, Message.RecipientType.TO));
    }

    @Nonnull
    public static List<InternetAddress> parseCcAddresses(@Nonnull MimeMessage mimeMessage) {
        return MimeMessageParser.parseInternetAddresses(MimeMessageParser.retrieveRecipients(mimeMessage, Message.RecipientType.CC));
    }

    @Nonnull
    public static List<InternetAddress> parseBccAddresses(@Nonnull MimeMessage mimeMessage) {
        return MimeMessageParser.parseInternetAddresses(MimeMessageParser.retrieveRecipients(mimeMessage, Message.RecipientType.BCC));
    }

    @Nullable
    public static Address[] retrieveRecipients(@Nonnull MimeMessage mimeMessage, Message.RecipientType recipientType) {
        try {
            return mimeMessage.getRecipients(recipientType);
        }
        catch (MessagingException e) {
            throw new MimeMessageParseException(String.format("Error getting [%s] recipient types", recipientType), (Exception)((Object)e));
        }
    }

    @Nonnull
    private static List<InternetAddress> parseInternetAddresses(@Nullable Address[] recipients) {
        ArrayList addresses = recipients != null ? Arrays.asList(recipients) : new ArrayList();
        ArrayList<InternetAddress> mailAddresses = new ArrayList<InternetAddress>();
        for (Address address : addresses) {
            if (!(address instanceof InternetAddress)) continue;
            mailAddresses.add((InternetAddress)address);
        }
        return mailAddresses;
    }

    @Nullable
    public static InternetAddress parseFromAddress(@Nonnull MimeMessage mimeMessage) {
        try {
            Address[] addresses = mimeMessage.getFrom();
            return addresses == null || addresses.length == 0 ? null : (InternetAddress)addresses[0];
        }
        catch (MessagingException e) {
            throw new MimeMessageParseException("Error parsing from-address", (Exception)((Object)e));
        }
    }

    @Nullable
    public static InternetAddress parseReplyToAddresses(@Nonnull MimeMessage mimeMessage) {
        try {
            Address[] addresses = mimeMessage.getReplyTo();
            return addresses == null || addresses.length == 0 ? null : (InternetAddress)addresses[0];
        }
        catch (MessagingException e) {
            throw new MimeMessageParseException("Error parsing replyTo addresses", (Exception)((Object)e));
        }
    }

    @Nullable
    public static String parseSubject(@Nonnull MimeMessage mimeMessage) {
        try {
            return mimeMessage.getSubject();
        }
        catch (MessagingException e) {
            throw new MimeMessageParseException("Error getting subject", (Exception)((Object)e));
        }
    }

    @Nullable
    public static String parseMessageId(@Nonnull MimeMessage mimeMessage) {
        try {
            return mimeMessage.getMessageID();
        }
        catch (MessagingException e) {
            throw new MimeMessageParseException("Error getting message ID", (Exception)((Object)e));
        }
    }

    static void moveInvalidEmbeddedResourcesToAttachments(ParsedMimeMessageComponents parsedComponents) {
        String htmlContent = parsedComponents.htmlContent;
        Iterator<Map.Entry<String, DataSource>> it = parsedComponents.cidMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, DataSource> cidEntry = it.next();
            String cid = MiscUtil.extractCID(cidEntry.getKey());
            if (htmlContent != null && htmlContent.contains("cid:" + cid)) continue;
            parsedComponents.attachmentList.add(new AbstractMap.SimpleEntry<String, DataSource>(cid, cidEntry.getValue()));
            it.remove();
        }
    }

    static {
        HEADERS_TO_IGNORE.add("Received");
        HEADERS_TO_IGNORE.add("Resent-Date");
        HEADERS_TO_IGNORE.add("Resent-From");
        HEADERS_TO_IGNORE.add("Resent-Sender");
        HEADERS_TO_IGNORE.add("Resent-To");
        HEADERS_TO_IGNORE.add("Resent-Cc");
        HEADERS_TO_IGNORE.add("Resent-Bcc");
        HEADERS_TO_IGNORE.add("Resent-Message-Id");
        HEADERS_TO_IGNORE.add("Date");
        HEADERS_TO_IGNORE.add("From");
        HEADERS_TO_IGNORE.add("Sender");
        HEADERS_TO_IGNORE.add("Reply-To");
        HEADERS_TO_IGNORE.add("To");
        HEADERS_TO_IGNORE.add("Cc");
        HEADERS_TO_IGNORE.add("Bcc");
        HEADERS_TO_IGNORE.add("Message-Id");
        HEADERS_TO_IGNORE.add("Subject");
        HEADERS_TO_IGNORE.add("Comments");
        HEADERS_TO_IGNORE.add("Keywords");
        HEADERS_TO_IGNORE.add("Errors-To");
        HEADERS_TO_IGNORE.add("MIME-Version");
        HEADERS_TO_IGNORE.add("Content-Type");
        HEADERS_TO_IGNORE.add("Content-Transfer-Encoding");
        HEADERS_TO_IGNORE.add("Content-MD5");
        HEADERS_TO_IGNORE.add(":");
        HEADERS_TO_IGNORE.add("Content-Length");
        HEADERS_TO_IGNORE.add("Status");
        HEADERS_TO_IGNORE.add("Content-Disposition");
        HEADERS_TO_IGNORE.add("size");
        HEADERS_TO_IGNORE.add("filename");
        HEADERS_TO_IGNORE.add("Content-ID");
        HEADERS_TO_IGNORE.add("name");
        HEADERS_TO_IGNORE.add("From");
    }

    public static class ParsedMimeMessageComponents {
        final Set<Map.Entry<String, DataSource>> attachmentList = new TreeSet<Map.Entry<String, DataSource>>(NaturalEntryKeyComparator.INSTANCE);
        final Map<String, DataSource> cidMap = new TreeMap<String, DataSource>();
        private final Map<String, Object> headers = new HashMap<String, Object>();
        private final List<InternetAddress> toAddresses = new ArrayList<InternetAddress>();
        private final List<InternetAddress> ccAddresses = new ArrayList<InternetAddress>();
        private final List<InternetAddress> bccAddresses = new ArrayList<InternetAddress>();
        private String messageId;
        private String subject;
        private InternetAddress fromAddress;
        private InternetAddress replyToAddresses;
        private InternetAddress dispositionNotificationTo;
        private InternetAddress returnReceiptTo;
        private InternetAddress bounceToAddress;
        private String plainContent;
        String htmlContent;

        public String getMessageId() {
            return this.messageId;
        }

        public Set<Map.Entry<String, DataSource>> getAttachmentList() {
            return this.attachmentList;
        }

        public Map<String, DataSource> getCidMap() {
            return this.cidMap;
        }

        public Map<String, Object> getHeaders() {
            return this.headers;
        }

        public List<InternetAddress> getToAddresses() {
            return this.toAddresses;
        }

        public List<InternetAddress> getCcAddresses() {
            return this.ccAddresses;
        }

        public List<InternetAddress> getBccAddresses() {
            return this.bccAddresses;
        }

        public String getSubject() {
            return this.subject;
        }

        public InternetAddress getFromAddress() {
            return this.fromAddress;
        }

        public InternetAddress getReplyToAddresses() {
            return this.replyToAddresses;
        }

        public InternetAddress getDispositionNotificationTo() {
            return this.dispositionNotificationTo;
        }

        public InternetAddress getReturnReceiptTo() {
            return this.returnReceiptTo;
        }

        public InternetAddress getBounceToAddress() {
            return this.bounceToAddress;
        }

        public String getPlainContent() {
            return this.plainContent;
        }

        public String getHtmlContent() {
            return this.htmlContent;
        }
    }
}

